package cn.com.duiba.sso.api.web.filterhandler.handler;

import javax.servlet.FilterChain;

import com.google.common.base.Objects;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandlerContext;
import cn.com.duiba.sso.api.web.tool.RequestTool;

/**
 * Created by liuyao on 2017/5/12.
 * 远程权限拦截系统(未迁移)
 */
public class AuthorityFilterHandler extends SsoFilterHandler {

    private RemoteAdminService remoteAdminService;

    private SystemEnum system;

    @Override
    protected Integer getOrder() {
        return -99;
    }

    @Override
    protected void init(SsoFilterHandlerContext context) {
        this.remoteAdminService = context.getRemoteService(RemoteAdminService.class);
        system = context.getSsoSystemProperties().getSystem();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        AdminDto admin = remoteAdminService.findAdmin(RequestTool.getAdminId()).getResult();
        if(Objects.equal(null,admin)){
            throw new SsoException("管理员不存在");
        }
        RequestTool.setAdmin(admin);
        if(!admin.getCompanyEnumSet().contains(system)){
            throw new SsoException("尊敬的"+admin.getName()+",你对"+system.getName()+"的执着给我们留下了深刻的印象,不过相关领导说你不能进");
        }
        return true;
    }
}
