package cn.com.duiba.sso.api.web.filterhandler.handler;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandlerContext;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.tool.RequestTool;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by liuyao on 2017/5/11.
 */
public class DefaultFilterHandler extends SsoFilterHandler {

    @Override
    protected Integer getOrder() {
        return SsoFilterHandler.DEFAULT_ORDER;
    }

    @Override
    protected void init(SsoFilterHandlerContext manager) {

    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        HttpServletResponse response = RequestTool.getResponse();
        HttpServletRequest request = RequestTool.getRequest();
        try{
            chain.doFilter(request,response);
        }catch (Exception e){
            throw new SsoException(e);
        }
        return true;
    }
}
