package cn.com.duiba.sso.api.web.filterhandler.handler;

import javax.servlet.FilterChain;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.web.tool.JsonRender;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Objects;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.filterhandler.SsoFilterHandlerContext;
import cn.com.duiba.sso.api.web.tool.CookieUtil;
import cn.com.duiba.sso.api.web.tool.RequestTool;

import java.net.URLEncoder;
import java.util.Map;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
public class LoginFilterHandler extends SsoFilterHandler {

    private RemoteSSOService remoteSSOService;
    private String loginUrl;
    private SystemEnum system;


    @Override
    protected Integer getOrder() {
        return -100;
    }

    @Override
    protected void init(SsoFilterHandlerContext context) {
        remoteSSOService = context.getRemoteService(RemoteSSOService.class);
        loginUrl = context.getSsoSystemProperties().getLoginUrl();
        system = context.getSsoSystemProperties().getSystem();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        String ticket = findTicket();
        DubboResult<Long> adminIdRes = remoteSSOService.verifyTicket(ticket);
        //未登录状态
        if(!adminIdRes.isSuccess() || Objects.equal(null,adminIdRes.getResult())){
            try{
                if(RequestTool.isAsynchronousRequests()){
                    RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JSONObject model = new JSONObject();
                    model.put("success",false);
                    model.put("notLogin",false);
                    model.put("message",adminIdRes.getMsg());
                    RequestTool.getResponse().getWriter().write(model.toJSONString());
                }else{
                    //附上当前请求地址,重定向到SSO登录页
                    String url = URLEncoder.encode(RequestTool.getUrl(),"utf-8");
                    RequestTool.getResponse().sendRedirect(getLoginRedirectUrl(url));
                }
            }catch (Exception e){
                throw new SsoException(e);
            }
            return false;
        }
        //注入adminId
        RequestTool.setAdminId(adminIdRes.getResult());
        //当通行令牌存在于链接参数中时,则把它持久到cookie中(链接中通行证的参数名和链接中的相同)
        if(RequestTool.getRequestParamMap().containsKey(CookieUtil.LOGIN_COOKIE_NAME)){
            CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);
        }
        return true;
    }

    /**
     * 获取令牌
     * @return
     */
    private String findTicket(){
        String ticketForUrl = RequestTool.getRequestParamMap().get(CookieUtil.LOGIN_COOKIE_NAME);
        if(StringUtils.isNotBlank(ticketForUrl)){
            return ticketForUrl;
        }
        return CookieUtil.getCookie(CookieUtil.LOGIN_COOKIE_NAME);
    }

    /**
     * 获取登录重定向地址
     * @param redirect
     * @return
     */
    private String getLoginRedirectUrl(String redirect){
        StringBuilder builder = new StringBuilder();
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&system=").append(system.getId());
        return builder.toString();
    }


}
