package cn.com.duiba.sso.api.web.tool;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;

/**
 * Created by liuyao on 2017/5/11.
 */
public class RequestParams {

    private Map<String, String> cookies = Collections.emptyMap();
    private Long adminId;
    private String url;
    private AdminDto admin;

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public String getUrl() {
        return url;
    }

    protected void addCookie(String name, String value){
        cookies.put(name,value);
    }

    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    public AdminDto getAdmin() {
        return admin;
    }

    public void setAdmin(AdminDto admin) {
        this.admin = admin;
    }

    public static RequestParams parse(HttpServletRequest request) {
        if(request==null) throw new SsoRunTimeException("RequestParams解析时的request不能为空");
        RequestParams rp = new RequestParams();

        Map<String,String> cookieMap = parseCookies(request);
        rp.url = parseUrl(request);
        rp.cookies = cookieMap;
        return rp;
    }

    private static String parseUrl(HttpServletRequest request){
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if(StringUtils.isNotBlank(queryString)) sb.append("?").append(queryString);
        return sb.toString();
    }

    private static Map<String,String> parseCookies(HttpServletRequest request){
        Cookie[] cookies=request.getCookies();
        Map<String,String> cookieMap = Maps.newHashMap();
        if(cookies!=null){
            for(Cookie cookie : cookies){
                cookieMap.put(cookie.getName(),cookie.getValue());
            }
        }
        return cookieMap;
    }
}
