package cn.com.duiba.sso.api.web.tool;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import com.google.common.base.Objects;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by liuyao on 2017/5/11.
 */
public class RequestTool {
    private static ThreadLocal<RequestTool> local = new ThreadLocal<>();

    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestParams params;

    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response){
        if(request==null) throw new SsoRunTimeException("RequestTool注入request为空");
        if(response==null) throw new SsoRunTimeException("RequestTool注入response为空");
        RequestTool tool = new RequestTool();
        tool.request = request;
        tool.response = response;
        tool.params = RequestParams.parse(request);
        local.set(tool);
    }

    private static RequestTool get(){
        if(local.get()==null) throw new SsoRunTimeException("请在登录拦截器中调用setRequestInThreadLocal");
        return local.get();
    }

    public static RequestParams getRequestParams(){
        return get().params;
    }


    public static HttpServletResponse getResponse(){
        return get().response;
    }

    public static HttpServletRequest getRequest(){
        return get().request;
    }

    public static void removeRequestInThreadLocal(){
        local.remove();
    }

    public static Long getAdminId(){
        RequestTool tool = RequestTool.get();
        return tool.params.getAdminId();
    }

    public static void setAdminId(Long adminId){
        RequestTool tool = RequestTool.get();
        tool.params.setAdminId(adminId);
    }

    public static AdminDto getAdmin() {
        RequestTool tool = RequestTool.get();
        return tool.params.getAdmin();
    }

    public static void setAdmin(AdminDto admin) {
        RequestTool tool = RequestTool.get();
        tool.params.setAdmin(admin);
    }

    public static void addCookie(Cookie cookie){
        if(cookie==null){
            return;
        }
        RequestTool tool = RequestTool.get();
        tool.params.addCookie(cookie.getName(),cookie.getValue());
        tool.response.addCookie(cookie);
    }

    public static String getUrl(){
        return get().params.getUrl();
    }

    public static boolean isHttpsRequest(){
        HttpServletRequest request= get().request;
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(String name){
        RequestTool tool = RequestTool.get();
        return tool.params.getCookie(name);
    }

    public static Boolean isLogin(){
        RequestTool tool = RequestTool.get();
        return Objects.equal(null,tool.params.getAdminId());
    }

    /**
     * 提取request中的参数
     * @return
     */
    public static Map<String,String> getRequestParamMap(){
        HttpServletRequest request= get().request;
        Map<String, String[]> map=request.getParameterMap();
        Map<String, String> resultMap=new HashMap<>();
        for(Map.Entry<String, String[]> entry :map.entrySet()){
            resultMap.put(entry.getKey(), entry.getValue()[0]);
        }
        return resultMap;
    }

    public static Boolean isAsynchronousRequests(){
        HttpServletRequest request= get().request;
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return (StringUtils.isNoneBlank(re) || StringUtils.isNoneBlank(accept) && accept.contains("json"));
    }
}
