package cn.com.duiba.sso.api.web.filter;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.com.duiba.sso.api.web.annotation.CanAccess;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.tool.JsonRender;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Controller;

/**
 * Created by liuyao on 2017/5/10.
 * 因为要兼容duiba-manager,无法写成容器启动方式
 */
public class SsoFilter implements Filter {

    private static Set<String> EXCLUDE_PATHS = Sets.newHashSet();

    private static SsoFilterHandlerQueue queue;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        EXCLUDE_PATHS.add("/favicon.ico");
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) resp;
        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request,response);
        try {
            String url = request.getRequestURI();
            if(queue==null || EXCLUDE_PATHS.contains(url) || url.contains(".")){
                chain.doFilter(request,response);
            }else{
                queue.doHandler(chain);
            }
        }catch (SsoException e){
            if (RequestTool.isAsynchronousRequests()){
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                RequestTool.getResponse().getWriter().write(JsonRender.failResult(e).toJSONString());
            }else{
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                RequestTool.getResponse().getWriter().write(e.getMessage());
            }
        }finally {
            RequestTool.removeRequestInThreadLocal();
        }
    }

    @Override
    public void destroy() {
        queue = null;
    }

    public static void setSsoFilterHanderQueue(SsoFilterHandlerQueue queue) {
        SsoFilter.queue = queue;
    }

    public static void setExcludePaths(Set<String> excludePaths){
        EXCLUDE_PATHS.addAll(excludePaths);
    }

    /**
     * 注入sso容器,构建拦截队列
     * @param context
     */
    public static void setSsoContext(SsoContext context){
        SsoFilterHandlerQueue queue = context.getBean(SsoFilterHandlerQueue.class);
        SsoFilter.setSsoFilterHanderQueue(queue);//注入拦截队列
        Set<Object> controllerSet = context.getBeansWithAnnotation(Controller.class);

        Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();
        Set<String> excludePaths = Sets.newHashSet();

        for( Object controller:controllerSet){
            Class<?> ultimateTargetClass;
            if(AopUtils.isAopProxy(controller)) {
                ultimateTargetClass = AopProxyUtils
                        .ultimateTargetClass(controller);
            }
            else {
                ultimateTargetClass = controller.getClass();
            }

            Method[] methods = ultimateTargetClass.getMethods();

            for(Method method:methods){
                CanAccess canAccess = method.getAnnotation(CanAccess.class);
                if(!Objects.equal(null,canAccess)){
                    excludePaths.addAll(splitter.splitToList(canAccess.value()));
                }
            }
        }
        SsoFilter.setExcludePaths(excludePaths);//注入白名单
    }

    public static int getHandlerNum(){
        return queue.size();
    }

    public static int getBaiNum(){
        return EXCLUDE_PATHS.size();
    }
}
