package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.logger.domain.AccessLog;
import cn.com.duiba.sso.api.web.logger.runnable.AccessLogger;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by liqing on 2017/7/27.
 */
@SsoComponent
public class AccessLogFilterHandler extends SsoFilterHandler {

    private SystemEnum system;
    private ExecutorService executorService;
    private RemoteManagerLogService remoteManagerLogService;

    @Override
    public void setContext(SsoContext context) {
        this.system = context.getSsoSystemProperties().getSystem();
        this.executorService = Executors.newCachedThreadPool();
        this.remoteManagerLogService = context.getBean(RemoteManagerLogService.class);

    }

    @Override
    public Integer getOrder() {
        return -98;
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        HttpServletRequest request = RequestTool.getRequest();
        AccessLog accessLog = new AccessLog();
        String url = request.getRequestURL().toString();
        String uri = request.getRequestURI();
        String ip = request.getRemoteAddr();
        AdminDto adminDto = RequestTool.getAdmin();
        String accessUser = adminDto.getName();
        String systemName = system.getName();
        Date accessDate = new Date();
        Long systemId = this.system.getId();
        accessLog.setAccessUser(accessUser);
        accessLog.setRequestUrl(url);
        accessLog.setRequestUri(uri);
        accessLog.setIp(ip);
        accessLog.setSystemId(systemId.intValue());
        accessLog.setBusinessSystem(systemName);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        accessLog.setAccessTime(sdf.format(accessDate));
        this.remoteManagerLogService.appendAccessLog(accessLog);
        return true;
    }
}
