package cn.com.duiba.sso.api.web.logger.runnable;

import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.logger.domain.AccessLog;
import cn.com.duiba.sso.api.web.tool.SsoUrl;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Future;

/**
 * Created by Administrator on 2017/7/31.
 */
public class AccessLogger  {

    private AccessLog accessLog;
    private RemoteManagerLogService remoteManagerLogService;
    private Logger logger = LoggerFactory.getLogger(AccessLogger.class);
    private static final AccessLogger accessLogger = new AccessLogger();
    private AccessLogger(){
    }

    public static AccessLogger getAccessLogger(){
        return accessLogger;
    }

    public void sendLog(String requestUrl,AccessLog accessLog) {
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.createDefault();
        try {
            httpclient.start();
            HttpPost request = new HttpPost(requestUrl);
            JSONObject jsonObject = JSONObject.fromObject(accessLog);
            String accessLogJson = jsonObject.toString();
            StringEntity input = new StringEntity(accessLogJson);
            input.setContentType("application/json");
            request.setEntity(input);
            Future<HttpResponse> responseFuture = httpclient.execute(request, null);
            HttpResponse hr = responseFuture.get();
            hr.getAllHeaders();
        } catch (UnsupportedEncodingException e) {
            logger.error(e.toString());
        } catch (Exception e){
            logger.error(e.toString());
        }
        finally
         {
            try {
                httpclient.close();
            } catch (IOException e) {
                logger.error(e.toString());
            }
        }
    }
}
