package cn.com.duiba.sso.api.web.logger.service;

import java.util.concurrent.ExecutorService;

import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.logger.SsoLogger;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;

import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.logger.runnable.SsoLoggerRunnable;
import cn.com.duiba.sso.api.web.tool.RequestParams;
import cn.com.duiba.sso.api.web.tool.RequestTool;

/**
 * Created by liuyao on 2017/6/19.
 */
@SsoComponent
public class SsoLoggerService implements SsoBeanAware {

    private ExecutorService executorService;

    private RemoteManagerLogService remoteManagerLogService;

    private SystemEnum system;
    /**
     * 由切面产生,如果没有此日志线程对象,则SsoLogger的无法打印日志
     */
    private ThreadLocal<SsoLoggerTheadContext> threadContext = new ThreadLocal();

    /**
     * 打印日志
     * @param json
     */
    public void log(JSONObject json){
        threadContext.get().addParams(json);
    }

    /**
     *
     * @param context
     */
    public void setThreadContext(SsoLoggerTheadContext context){
        //不支持嵌套(如果要支持嵌套,threadContext的数据结构需要弄成栈表形式)
        if(threadContext.get()==null){
            threadContext.set(context);
        }
    }

    public void flushThreadContext(){
        SsoLoggerTheadContext context = threadContext.get();
        if(Objects.equal(null,context)){
            return;
        }
        //克隆出一个 RequestParams
        RequestParams params = RequestTool.getRequestParams();
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setSystem(system);
        runnable.setRequestParams(params);
        runnable.setContext(context);
        runnable.setRemoteManagerLogService(remoteManagerLogService);
        executorService.submit(runnable);
        threadContext.remove();
    }

    @Override
    public void setContext(SsoContext context) {
        executorService = context.getBean(ExecutorService.class);
        remoteManagerLogService = context.getBean(RemoteManagerLogService.class);
        system = context.getSsoSystemProperties().getSystem();
        SsoLogger.setSsoLoggerService(this);
    }
}
