package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.ui.SsoUIProperties;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author liuyao
 */
@Slf4j
@Service
public class SsoUIResManager {

    @Value("classpath:ui/main.js")
    private org.springframework.core.io.Resource mainJs;
    @Value("classpath:temp/index.html")
    private org.springframework.core.io.Resource mainHomeIndex;
    @Resource
    private SsoUIProperties ssoUIProperties;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private MumeLoader mumeLoader;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private EnvironmentService environmentService;

    private final Map<String,String> jsMap = Maps.newConcurrentMap();

    private String webTitle = "服务综合治理平台";

    public void regestModule(String name,String configuration){
        jsMap.put(name,configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    protected String indexHtml() throws IOException {

        JSONObject model = new JSONObject();
        model.put("rootPath",ssoProperties.getRootPath());
        model.put("webTitle",webTitle);

        Environment environment = requestEnvironmentDecisionMaker.getRequestEnvironment();

        model.put("environment",environment.getEnvId());
        model.put("cluster",environmentService.currentClusterKey());
        model.put("uiVersion",ssoUIProperties.getVersion());
        List<SsoUIMume> ssoUIMume =  mumeLoader.loadUIMume();
        model.put("mumeList", JSONArray.toJSONString(ssoUIMume));
        model.put("rootMoudles",JSONObject.toJSONString(jsMap));

        CharSource source = Resources.asCharSource(mainHomeIndex.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }

}
