package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.constants.SsoProperties;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@Order(Ordered.HIGHEST_PRECEDENCE)
@WebFilter(filterName = "uiBootFilter", urlPatterns = "/*",dispatcherTypes = DispatcherType.REQUEST)
public class SsoUiRootFilter implements Filter {

    private static String UI_BOOT_FORWARD_PATH = "/forward";

    @Resource
    private SsoProperties ssoProperties;

    private Boolean active = false;

    @Override
    public void init(FilterConfig filterConfig){
        //nothing
    }

    @PostConstruct
    public void initSsoUiRootFilter(){
        this.active = StringUtils.isNotBlank(ssoProperties.getRootPath()) && StringUtils.startsWith(ssoProperties.getRootPath(),"/");
        UI_BOOT_FORWARD_PATH = ssoProperties.getRootPath() + UI_BOOT_FORWARD_PATH;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest)req;

        String path = request.getRequestURI();

        if(!active || !StringUtils.startsWith(path,ssoProperties.getRootPath())){
            chain.doFilter(req,response);
            return;
        }
        boolean needForward = StringUtils.startsWith(path,UI_BOOT_FORWARD_PATH);
        if(!needForward){
            chain.doFilter(req,response);
            return;
        }
        path = path.replace(UI_BOOT_FORWARD_PATH,"");
        request.getRequestDispatcher(path).forward(request,response);//转发正确的控制器
    }

    @Override
    public void destroy() {
        //nothing
    }
}
