package cn.com.duiba.sso.ui.resource;


import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.domain.enums.AdminApplicationRelation;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationPermissionService;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "${duiba.sso.root-path:'/sso'}/uiboot")
public class UiBootDataController {

    @Resource
    private RemoteApplicationService remoteApplicationService;
    @Resource
    private RemoteApplicationPermissionService remoteApplicationPermissionService;


    @CanAccess
    @AuthCanAccess
    @GetMapping(value = "/findAllApplication")
    public JsonRender findAllApplication(){

        List<ApplicationDto> apps = remoteApplicationService.findAllApplication();

        JsonRender model = JsonRender.successResult();
        JSONArray applications = new JSONArray();
        for(ApplicationDto system:apps){
            JSONObject app = new JSONObject();
            app.put("alias",system.getAppAlias());
            app.put("name",system.getAppName());
            app.put("id",system.getId());
            applications.add(app);
        }
        model.put("applications",applications);
        return model;
    }

    @CanAccess
    @AuthCanAccess
    @GetMapping(value = "/findConcernApplications")
    public JsonRender findConcernApplications(){
        List<ApplicationDto> apps = remoteApplicationService.findAllApplication();
        Set<String> applications = apps.stream().map(ApplicationDto::getAppAlias).collect(Collectors.toSet());
        JsonRender model = JsonRender.successResult();
        model.put("applications",applications);
        return model;
    }



}
