package cn.com.duiba;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportResource;

/**
 * Created by xuezhaoming on 16/5/13.
 */
@SpringBootApplication
@ImportResource({ "spring/spring-config.xml", "spring/spring-job.xml" })
public class Application {

    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        try {
            SpringApplication.run(Application.class, args);
        } catch (Exception e) {
            LOGGER.error("Application start error :", e);
            System.exit(-1);
        }
    }
}
