/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba;

import cn.com.duiba.wolf.utils.ClassUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@ImportResource(value={"spring/spring-config.xml"})
public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        try {
            ClassUtils.checkSerializable((String[])new String[]{"cn.com.duiba.stock.service.api.dto"});
            SpringApplication sa = new SpringApplication(new Object[]{Application.class});
            HashMap defaultMap = Maps.newHashMap();
            defaultMap.put("spring.config.location", "http://dev.config.duibar.com:1024/stock-service-dev.properties");
            sa.setDefaultProperties((Map)defaultMap);
            sa.run(args);
        }
        catch (Exception e) {
            LOGGER.error("Application start error :", (Throwable)e);
            System.exit(-1);
        }
    }
}

