/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.stock.service.deploy.controller;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping
public class AppController {
    public static final String RETURNSTR = "Welcome to duiba stock service";
    @Resource
    private RedisClient redisClient;
    @Resource
    private RemoteStockService remoteStockService;

    @ResponseBody
    @RequestMapping(value={"/"})
    public String index() {
        return RETURNSTR;
    }

    @ResponseBody
    @RequestMapping(value={"/findStock"})
    public String findStock(HttpServletRequest request) {
        Long stockId = Long.valueOf(request.getParameter("stockId"));
        DubboResult ret = this.remoteStockService.find(stockId.longValue());
        return String.valueOf(ret.getResult());
    }

    @ResponseBody
    @RequestMapping(value={"/batchFindStock"})
    public String batchFindStock(HttpServletRequest request) {
        String stockIdsStr = request.getParameter("stockIds");
        String[] ids = stockIdsStr.split(",");
        ArrayList<Long> stockIds = new ArrayList<Long>();
        for (String str : ids) {
            stockIds.add(Long.valueOf(str));
        }
        DubboResult rets = this.remoteStockService.findBatchByIds(stockIds);
        return String.valueOf(((List)rets.getResult()).size());
    }

    @ResponseBody
    @RequestMapping(value={"/consumeStock"})
    public String consumeStock(HttpServletRequest request) {
        String reqBiz = "perf_" + UUID.randomUUID().toString();
        Long stockId = Long.valueOf(request.getParameter("stockId"));
        int consumeStockType = Integer.parseInt(request.getParameter("consumeStockType"));
        DubboResult ret = this.remoteStockService.consumeStockOne(consumeStockType, reqBiz, stockId);
        return JSONObject.toJSONString((Object)ret);
    }
}

