package cn.com.duiba;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ImportResource;

import cn.com.duiba.wolf.utils.ClassUtils;

import com.google.common.collect.Maps;

/**
 * Created by xuezhaoming on 16/5/13.
 */
@SpringBootApplication
@ImportResource({ "spring/spring-config.xml" })
public class Application {

	private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

	public static void main(String[] args) {
		try {
			ClassUtils.checkSerializable("cn.com.duiba.stock.service.api.dto");
			SpringApplication sa = new SpringApplication(Application.class);
			Map<String, Object> defaultMap = Maps.newHashMap();
			defaultMap.put("spring.config.location", "http://dev.config.duibar.com:1024/stock-service-dev.properties");
			sa.setDefaultProperties(defaultMap);
			sa.run(args);
		} catch (Exception e) {
			LOGGER.error("Application start error :", e);
			System.exit(-1);
		}
	}
}
