package cn.com.duiba.stock.service.deploy.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;

import com.alibaba.fastjson.JSONObject;

/**
 * 接收HTTP请求
 */
@Controller
@RequestMapping
public class AppController {

	public static final String RETURNSTR = "Welcome to duiba stock service";

	@Resource
	private RedisClient redisClient;
	@Resource
	private RemoteStockService remoteStockService;

	/**
	 * 跟路径
	 * 
	 * @return
	 */
	@ResponseBody
	@RequestMapping("/")
	public String index() {
		return RETURNSTR;
	}

	/**
	 * 查询库存
	 * 
	 * @param request
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/findStock")
	public String findStock(HttpServletRequest request) {
		Long stockId = Long.valueOf(request.getParameter("stockId"));
		DubboResult<Long> ret = remoteStockService.find(stockId);
		return String.valueOf(ret.getResult());
	}

	/**
	 * 批量查询库存
	 * 
	 * @param request
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/batchFindStock")
	public String batchFindStock(HttpServletRequest request) {
		String stockIdsStr = request.getParameter("stockIds");
		String[] ids = stockIdsStr.split(",");
		List<Long> stockIds = new ArrayList<>();
		for (String str : ids) {
			stockIds.add(Long.valueOf(str));
		}
		DubboResult<List<StockDto>> rets = remoteStockService.findBatchByIds(stockIds);
		return String.valueOf(rets.getResult().size());
	}

	/**
	 * 扣库存
	 * 
	 * @param request
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "/consumeStock")
	public String consumeStock(HttpServletRequest request) {
		String reqBiz = "perf_" + UUID.randomUUID().toString();
		Long stockId = Long.valueOf(request.getParameter("stockId"));
		int consumeStockType = Integer.parseInt(request.getParameter("consumeStockType"));
		DubboResult<Boolean> ret = remoteStockService.consumeStockOne(consumeStockType, reqBiz, stockId);
		return JSONObject.toJSONString(ret);
	}

}
