package cn.com.duiba.stock.service.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by guoeryang on 2016/6/24.
 * 
 * @see SaleLimitTypes relationType请使用常量SaleLimitType.XX
 */
public interface RemoteSaleLimitService {
	
    /**
     * 查询今日销量
     * @param relationType  @see SaleLimitTypes
     */
	public DubboResult<Long> findSaleCountToday(String relationType,String relationId);
    
    /**
     * 添加一个销量 
     *  type          业务类型  @see SaleLimitTypes
     *  id            业务id1
     *  bizId         业务id2
     *  upperCount    销量上限
     */
	public DubboResult<Boolean> addSaleToday(String type,String relationId,String reqbizId, int upperCount);
    
    /**
     * 回滚一个销量(隔天不回滚)
	 *
	 * @author xuhengfei
	 * @param type   @see SaleLimitTypes
	 * @param relationId
	 * @param reqbizId
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<Boolean> rollbackSaleToday(String type,String relationId,String reqbizId);
}
