package cn.com.duiba.stock.service.api.remoteservice;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/16.
 */
public interface RemoteStockBackendService {

    /**
     * 增加count 个指定库存ID的库存
     *
     * @param stockId 库存ID
     * @param count 库存个数
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> increaseItemStock(long stockId, long count);

    /**
     * 减少count 个指定库存ID的库存
     *
     * @param stockId 库存ID
     * @param count 减少库存个数
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> decreaseItemStock(long stockId, long count);

    /**
     * 新增商品库存
     *
     * @param gid 商品ID
     * @param stock 库存量
     * @return 库存ID
     */
    DubboResult<Long> newStock(long gid, long stock);

    /**
     * 根据库存ID 查询库存
     * 
     * @param stockID 库存ID
     * @return 库存数据
     */
    DubboResult<Long> find(long stockID);

    /**
     * 获取总库存
     * 
     * @param stockId 库存ID
     * @return 总库存
     */
    DubboResult<Long> findTotalStock(long stockId);
}
