package cn.com.duiba.stock.service.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/16.
 */
public interface RemoteStockService {

    /**
     * 获取指定库存ID的库存数量
     *
     * @param stockId 库存ID
     * @return 库存数量
     */
    DubboResult<Long> find(long stockId);

    /**
     * 批量获取库存
     *
     * @param stockIds 库存ID集合
     * @return 集合 key :库存ID value : 库存量,最大只允许100
     */
    DubboResult<Map<Long, Long>> findBatch(List<Long> stockIds);

    /**
     * 加少库存ID指定的库存 1
     *
     * @param stockId 库存ID
     * @param reqBiz 业务唯一ID，用于幂等性判断
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> decreaseGoodStock(long stockId, String reqBiz);

    /**
     * 批量减少库存ID指定的库存 1
     *
     * @param stockIds 库存ID, 必须且只能包含两位
     * @param reqBiz 业务唯一ID，用于幂等性判断
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> decreaseGoodStock(List<Long> stockIds, String reqBiz);

    /**
     * 增加库存ID指定的库存 1
     *
     * @param stockId 库存ID
     * @param reqBiz 业务唯一ID，用于幂等性判断
     * @return true :成功 flase : 失败
     */
    DubboResult<Boolean> increaseItemStock(long stockId, String reqBiz);
}
