package cn.com.duiba.stock.service.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 聚宝盆卡券库存DTO
 */
public class JbpStockRecordDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * mng商品id
     */
    private Long itemId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * appid
     */
    private Long appId;

    /**
     * 聚宝盆需求id
     */
    private Long demandId;

    /**
     * 聚宝盆需求名称
     */
    private String demandName;

    /**
     * 聚宝盆商品id
     */
    private Long jbpGoodsId;


    /**
     * 聚宝盆id，用于回退库存
     */
    private Long jbpAppItemId;

    /**
     * 商家编码
     */
    private String specId;

    /**
     * 总库存
     */
    private Long totalStock;

    /**
     * 已使用库存
     */
    private Long usedStock;

    /**
     * 已回退库存
     */
    private Long rolledBackStock;

    /**
     * 版本号（乐观锁）
     */
    private Long version;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getDemandId() {
        return demandId;
    }

    public void setDemandId(Long demandId) {
        this.demandId = demandId;
    }

    public String getDemandName() {
        return demandName;
    }

    public void setDemandName(String demandName) {
        this.demandName = demandName;
    }

    public Long getJbpGoodsId() {
        return jbpGoodsId;
    }

    public void setJbpGoodsId(Long jbpGoodsId) {
        this.jbpGoodsId = jbpGoodsId;
    }

    public Long getJbpAppItemId() {
        return jbpAppItemId;
    }

    public void setJbpAppItemId(Long jbpAppItemId) {
        this.jbpAppItemId = jbpAppItemId;
    }

    public String getSpecId() {
        return specId;
    }

    public void setSpecId(String specId) {
        this.specId = specId;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public Long getUsedStock() {
        return usedStock;
    }

    public void setUsedStock(Long usedStock) {
        this.usedStock = usedStock;
    }

    public Long getRolledBackStock() {
        return rolledBackStock;
    }

    public void setRolledBackStock(Long rolledBackStock) {
        this.rolledBackStock = rolledBackStock;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
}

