package cn.com.duiba.stock.service.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.stock.service.api.constant.SaleLimitTypes;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by guoeryang on 2016/6/24.
 * 
 * @see SaleLimitTypes relationType请使用常量SaleLimitType.XX
 */
@AdvancedFeignClient
public interface RemoteSaleLimitService {
	
    /**
     * 查询今日销量
     * @param relationType
     * @param relationId
     * @return
     */
	public DubboResult<Long> findSaleCountToday(Integer relationType,String relationId);
    
 
	/**
     * 批量查询今日销量
     * @param relationType
     * @param relationIds
     * @return relationId <-> sales
     */
    public DubboResult<Map<String, Long>> findSaleCountTodayBatch(Integer relationType, List<String> relationIds);
    
	/**
     * 添加一个销量 
	 * @param type 业务类型  
	 * @param relationId 业务id1
	 * @param reqbizId 业务id2
	 * @param upperCount 销量上限
	 * @return
	 */
	public DubboResult<Boolean> addSaleToday(Integer type,String relationId,String reqbizId, int upperCount);
    
    /**
     * 回滚一个销量(隔天不回滚)
	 *
	 * @author xuhengfei
	 * @param type
	 * @param relationId
	 * @param reqbizId
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<Boolean> rollbackSaleToday(Integer type,String relationId,String reqbizId);
}
