package cn.com.duiba.supplier.center.api.remoteservice.orders;


import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.SupplyOrdersDto;
import cn.com.duiba.supplier.center.api.request.order.QueryOrderListRequest;

import javax.annotation.CheckForNull;
import java.util.List;


/**
 * Created by hww on 2018/12/13 3:16 PM.
 */
@AdvancedFeignClient
public interface RemoteSupplyOrdersBackedService {

    /**
     * 根据采购单号查询采购单
     */
    @CheckForNull
    List<SupplyOrdersDto> findBySupplyOrderNum(Long supplyOrderNum);

    /**
     * 根据采购订单和子订单号查询，子订单可为空，兼容老数据
     * @param supplyOrderNum
     * @param ordersItemId
     * @return
     */
    SupplyOrdersDto selectBySupplyOrderNumAndOrdersItemId(Long supplyOrderNum, Long ordersItemId);

    /**
     * 根据第三方订单号查询采购单
     */
    @CheckForNull
    List<SupplyOrdersDto> findByThirdOrderNum(String thirdOrderNum);

    /**
     * 根据第三方订单号和子订单号查询，子订单可为空，兼容老数据
     * @param thirdOrderNum
     * @param ordersItemId
     * @return
     */
    SupplyOrdersDto selectByThirdOrderNumAndOrdersItemId(String thirdOrderNum, Long ordersItemId);

    /**
     * 根据供应商订单号查询采购单
     */
    @CheckForNull
    SupplyOrdersDto findByBizNo(String bizNo, Integer supplierType);

    /**
     * 分页查询采购单
     */
    Page<SupplyOrdersDto> findPage(QueryOrderListRequest request);

    /**
     * 根据供应商ID及商品类型查询待发货的订单
     */
    @CheckForNull
    List<SupplyOrdersDto> selectWaitSendBySupplierId(Integer supplierType, String itemType);

    List<SupplyOrdersDto> selectWaitSendBySupplierIdAndNums(Integer supplierType, List<Long> supplyOrderNumList);

    List<SupplyOrdersDto> findByCondition(QueryOrderListRequest request);

    /**
     * 根据采购单号集合查询采购单信息
     *  至多一次查询500个采购单号  超过500个 返回空集合
     *
     * @param supplyOrderNumList
     * @return
     */
    List<SupplyOrdersDto> selectByOrderNumList(List<Long> supplyOrderNumList);

    /**
     * 根据第三方单号集合查询采购单信息
     *  至多一次查询500个采购单号  超过500个 返回空集合
     *
     * @param thirdOrderNumList
     * @return
     */
    List<SupplyOrdersDto> selectByThirdOrderNumList(List<String> thirdOrderNumList);

    /**
     * 校验是否导入订单（返回存在的三方订单num）
     * @param thirdOrderNums
     * @return
     */
    List<String> checkContain(List<String> thirdOrderNums);

    /**
     * 更新收获地址
     * @param supplyOrdersDto
     * @return
     */
    int updateAddress(SupplyOrdersDto supplyOrdersDto);

}
