package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuiBaSupplyOrdersDto;
import cn.com.duiba.supplier.center.api.request.order.DuiBaSupplyOrderPurchaseRequest;
import cn.com.duiba.supplier.center.api.request.order.QueryDuiBaSupplyOrdersPageRequest;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDuiBaSupplyOrderService {

    PurchaseOrderResponse purchaseOrder(DuiBaSupplyOrderPurchaseRequest request);

    DuiBaSupplyOrdersDto findByThirdOrderNumAndAppId(String thirdOrderNum, Long appId);

    List<DuiBaSupplyOrdersDto> findByThirdOrderNum(String thirdOrderNum);

    DuiBaSupplyOrdersDto findBySupplyOrderNum(Long supplyOrderNum);

    boolean updateRemarksByOrderNum(Long supplyOrderNum, String remarks);

    boolean expressSend(Long supplyOrderNum, Long ordersItemId, String expressName, String expressNo);

    Page<DuiBaSupplyOrdersDto> findPage(QueryDuiBaSupplyOrdersPageRequest query);

    Integer findTotalCount(QueryDuiBaSupplyOrdersPageRequest query);

    List<DuiBaSupplyOrdersDto> findList(QueryDuiBaSupplyOrdersPageRequest query);

    /**
     * 取消待发货实物订单
     * @param supplyOrderNum  采购单号
     * @param cancelReason    取消原因
     * @throws BizException   取消失败抛出异常
     */
    void cancelObjectOrder(Long supplyOrderNum, Long ordersItemId, String cancelReason) throws BizException;

    /**
     * 根据采购单号 查询APP名称
     * DuiBaSupplyOrdersDto对象只会返回两个值  appName和supplyOrderNum,supplier,sku_info
     * @param supplyOrderNums
     * @return
     */
    List<DuiBaSupplyOrdersDto> findAppNameBySupplyOrderNum(List<Long> supplyOrderNums);

}
