package cn.com.duiba.supplier.center.api.remoteservice.supplier;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplierInfoDto;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplierItemDto;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplierParam;

import java.util.List;


/**
 * @author py
 */
@AdvancedFeignClient
public interface RemoteSupplierItemService {

    /**
     * 供应商关联商品
     * @param supplierId
     * @param appItemIds
     * @return
     */
    void relateSupplierItem(Long supplierId, List<Long> appItemIds);

    /**
     * 删除供应商关联商品
     * @param supplierItemId
     * @return
     */
    Boolean delSupplierItem(Long supplierItemId);

    /**
     * 查询供应商关联商品分页
     * @param param
     * @return
     */
    Page<SupplierItemDto> querySupplierItem(SupplierParam param);

    /**
     * 查询已经关联供应商的商品id
     * @param appItemIds
     * @return 已经关联供应商的商品id
     */
    List<Long> queryRelatedItemId(List<Long> appItemIds);

    /**
     * 根据商品id查询供应商信息
     * @param appItemId
     * @return
     */
    SupplierInfoDto querySupplierInfoByAppItemId(Long appItemId);
}
