package cn.com.duiba.supplier.center.api.remoteservice.orders;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.OrderOperationImportRecordDto;
import cn.com.duiba.supplier.center.api.params.OrderOperationQueryParam;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/12/6 下午2:57
 */
@AdvancedFeignClient
public interface RemoteOrderOperationRecordService {

    OrderOperationImportRecordDto findById(Long id);

    Long insert(OrderOperationImportRecordDto recordDto);

    Boolean update(OrderOperationImportRecordDto recordDto);

    Page<OrderOperationImportRecordDto> findPage(OrderOperationQueryParam param);

    /**
     * 微信立减金，处理中订单，重试
     * @param orderNum
     * @param stockId
     * @throws
     */
    void wxCouponReTry(String orderNum, String stockId) throws Exception;
}
