package cn.com.duiba.supplier.center.api.request.order;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.supplier.center.api.params.PhonebillParam;
import cn.com.duiba.supplier.center.api.params.WxCouponParam;

import java.io.Serializable;

/**
 *  兑吧采购单下单请求
 *  */
public class DuiBaSupplyOrderPurchaseRequest implements Serializable {

    private static final long serialVersionUID = 986875926990371434L;
    /** 开发者商品id */
    private AppItemDto appItem;
    /** 开发者商品skuId */
    private AppItemSkuDto appItemSku;
    /** 开发者应用id */
    private Long appId;
    /** 开发者应用名 */
    private String appName;
    /** 实物商品收货人电话 */
    private String phone;
    /** 实物商品收货人详情地址 */
    private String address;
    /** 实物商品收货人姓名 */
    private String name;
    /** 实物商品收货地址 省 */
    private String province;
    /** 实物商品收货地址 市 */
    private String city;
    /** 实物商品收货地址 区、县 */
    private String district;
    /** 实物商品收货地址 街道 */
    private String street;
    /** 第三方订单 */
    private String thirdOrderNum;
    /** 开发者id */
    private Long developerId;

    /**
     * 话费参数
     */
    private PhonebillParam phonebillParam;

    /**
     * 虚拟商品充值账号
     * @return
     */
    private String account;

    /**
     * 微信立减金参数
     */
    private WxCouponParam wxCouponParam;

    /**
     * 金额 单位分
     */
    private Long amount;

    /**
     * 开发者用户ID
     */
    private String partnerUserId;

    /**
     * 虚拟商品扩展字段
     */
    private String extraInfo;

    /**
     * 是否子订单
     */
    private boolean isSubSupplyOrderNum = false;

    private Long rechargeOrderNum;

    public Long getRechargeOrderNum() {
        return rechargeOrderNum;
    }

    public void setRechargeOrderNum(Long rechargeOrderNum) {
        this.rechargeOrderNum = rechargeOrderNum;
    }

    public boolean isSubSupplyOrderNum() {
        return isSubSupplyOrderNum;
    }

    public void setSubSupplyOrderNum(boolean subSupplyOrderNum) {
        isSubSupplyOrderNum = subSupplyOrderNum;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public WxCouponParam getWxCouponParam() {
        return wxCouponParam;
    }

    public void setWxCouponParam(WxCouponParam wxCouponParam) {
        this.wxCouponParam = wxCouponParam;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public PhonebillParam getPhonebillParam() {
        return phonebillParam;
    }

    public void setPhonebillParam(PhonebillParam phonebillParam) {
        this.phonebillParam = phonebillParam;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public AppItemDto getAppItem() {
        return appItem;
    }

    public void setAppItem(AppItemDto appItem) {
        this.appItem = appItem;
    }

    public AppItemSkuDto getAppItemSku() {
        return appItemSku;
    }

    public void setAppItemSku(AppItemSkuDto appItemSku) {
        this.appItemSku = appItemSku;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getThirdOrderNum() {
        return thirdOrderNum;
    }

    public void setThirdOrderNum(String thirdOrderNum) {
        this.thirdOrderNum = thirdOrderNum;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }
}
