package cn.com.duiba.supplier.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧为开发者提供供应商服务
 * 兑吧供应商订单
 */
public class DuiBaSupplyOrdersDto implements Serializable {
    private static final long serialVersionUID = 4678456740718270904L;

    public static final String EXPRESS_INFO_KEY_CODE = "code";
    public static final String EXPRESS_INFO_KEY_VOUCHER_ID = "voucher_id";
    public static final String EXPRESS_INFO_KEY_COUPON_ID = "coupon_id";
    public static final String EXPRESS_INFO_KEY_ACCOUNT = "acc";
    public static final String EXPRESS_INFO_KEY_PASSWORD = "psd"; //NOSONAR
    public static final String EXPRESS_INFO_KEY_EXPRESS_NO = "eno";
    public static final String EXPRESS_INFO_KEY_EXPRESS_COMPANY_NAME = "ecn";
    public static final String EXPRESS_INFO_KEY_LINK = "link";
    public static final String EXPRESS_INFO_KEY_OVERDUE = "overdue";
    public static final String EXPRESS_INFO_KEY_PRE_ORDER = "pre";
    public static final String EXPRESS_INFO_KEY_WX_REDPACK_ORDER = "wxRedpack";
    public static final String EXPRESS_INFO_KEY_WX_REDPACK_URL_ORDER = "wxRedpackUrl";

    public static final String EXPRESS_INFO_PHONE_NUMBER = "phoneNumber";
    public static final String EXPRESS_INFO_PHONE_FACE_PRICE = "phoneFacePrice";
    public static final String EXPRESS_INFO_PHONE_CAT_NAME = "phoneCatName";
    public static final String EXPRESS_INFO_PHONE_PROVINCE = "phoneProvince";
    public static final String EXPRESS_INFO_CHARGE_AMOUNT = "amount";

    /**
     * 主键ID
     */
    private Long id;
    /**
     * 采购单单号
     */
    private Long supplyOrderNum;

    /**
     * 分销商订单号
     */
    private String thirdOrderNum;

    /**
     * 分销商id
     */
    private Long appId;

    /**
     * 分销商名称
     */
    private String appName;

    /**
     * 订单商品类型 object-实物 coupon-优惠券 cryptocard-卡密
     */
    private String itemType;

    /**
     * 下单时间
     */
    private Date purchaseTime;

    /**
     * 采购单状态 100-初始化 200-待发货 998-交易成功 999-交易失败
     */
    private Integer orderStatus;

    /**
     * 供货价
     */
    private Long totalPrice;
    /**
     * 成本价
     */
    private Long costPrice;

    /**
     * 供应商名称
     */
    private String supplier;

    /**
     * 收货人姓名
     */
    private String name;

    /**
     * 收货地址 省
     */
    private String province;

    /**
     * 收货地址 市
     */
    private String city;

    /**
     * 收货地址 区县
     */
    private String district;

    /**
     * 收货地址 街道
     */
    private String street;
    /**
     * 备注
     */
    private String remarks;

    /**
     * 收货地址
     */
    private String address;

    /**
     * 收货电话
     */
    private String phone;

    /**
     * 快递信息
     */
    private String expressInfo;

    /**
     * 商品信息
     */
    private String skuInfo;

    /**
     * 订单失败原因
     */
    private String failReason;
    /**
     * appItemId
     */
    private Long appItemId;
    /**
     * appItemSkuId
     */
    private Long appItemSkuId;
    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否是新供应商订单
     * 0 默认 老采购单
     * 1 新供应商订单
     */
    private Integer type;

    /**
     * 供应商父订单号
     */
    private String supplierParentOrderId;
    /**
     * 供应商子订单号
     */
    private String supplierSubOrderId;
    /**
     * 分销商父订单号
     */
    private String distributorsParentOrderId;
    /**
     * 分销商子订单号
     */
    private String distributorsSubOrderId;

    /**
     * 充值账号
     */
    private String rechargeAccount;

    /**
     * 开发者用户ID
     */
    private String partnerUserId;

    /**
     * 额外信息
     */
    private String extraInfo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRechargeAccount() {
        return rechargeAccount;
    }

    public void setRechargeAccount(String rechargeAccount) {
        this.rechargeAccount = rechargeAccount;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSupplierParentOrderId() {
        return supplierParentOrderId;
    }

    public void setSupplierParentOrderId(String supplierParentOrderId) {
        this.supplierParentOrderId = supplierParentOrderId;
    }

    public String getSupplierSubOrderId() {
        return supplierSubOrderId;
    }

    public void setSupplierSubOrderId(String supplierSubOrderId) {
        this.supplierSubOrderId = supplierSubOrderId;
    }

    public String getDistributorsParentOrderId() {
        return distributorsParentOrderId;
    }

    public void setDistributorsParentOrderId(String distributorsParentOrderId) {
        this.distributorsParentOrderId = distributorsParentOrderId;
    }

    public String getDistributorsSubOrderId() {
        return distributorsSubOrderId;
    }

    public void setDistributorsSubOrderId(String distributorsSubOrderId) {
        this.distributorsSubOrderId = distributorsSubOrderId;
    }

    public Long getSupplyOrderNum() {
        return supplyOrderNum;
    }

    public void setSupplyOrderNum(Long supplyOrderNum) {
        this.supplyOrderNum = supplyOrderNum;
    }

    public String getThirdOrderNum() {
        return thirdOrderNum;
    }

    public void setThirdOrderNum(String thirdOrderNum) {
        this.thirdOrderNum = thirdOrderNum;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Date getPurchaseTime() {
        return purchaseTime;
    }

    public void setPurchaseTime(Date purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Long getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Long totalPrice) {
        this.totalPrice = totalPrice;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExpressInfo() {
        return expressInfo;
    }

    public void setExpressInfo(String expressInfo) {
        this.expressInfo = expressInfo;
    }

    public String getSkuInfo() {
        return skuInfo;
    }

    public void setSkuInfo(String skuInfo) {
        this.skuInfo = skuInfo;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemSkuId() {
        return appItemSkuId;
    }

    public void setAppItemSkuId(Long appItemSkuId) {
        this.appItemSkuId = appItemSkuId;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Long getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(Long costPrice) {
        this.costPrice = costPrice;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }
}
