package cn.com.duiba.supplier.center.api.enums;

import cn.com.duiba.supplier.center.api.dto.SupplierDto;
import cn.com.duiba.supplier.center.api.remoteservice.supplier.RemoteSupplierService;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

/**
 * 使用最近的供应商工具，方便管理后台可配置，近实时更新新的供应商，缺点是基于缓存，会有不一致的缓存问题
 * 对于新增供应商的配置，是比较方便的，满足绝大部分使用场景。
 * @Author 刘凯
 * @Date 2023/10/31 11:41 AM （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@Component
public class SupplyTypeEnumUtil implements CommandLineRunner {

    //直播 id 固定写死
    public static final  Long DUIBA_LIVE_SUPPLIER_PLATFORM = 24L;

    private static final Logger LOGGER = LoggerFactory.getLogger(SupplyTypeEnumUtil.class);



    @Autowired
    private RemoteSupplierService remoteSupplierService;

    private static RemoteSupplierService remoteSupplierServicestatic;
    private static final Map<String,SupplierDto > supplierInfoMap = new ConcurrentHashMap<>();

    private static final Cache<String, SupplierDto> SUPPLIER_INFO_CACHE = Caffeine.newBuilder().expireAfterWrite(3, TimeUnit.MINUTES).maximumSize(100)
            .build();

    @Override
    public void run(String... args) throws Exception {
        //方便可以在 cache 中使用
        remoteSupplierServicestatic = remoteSupplierService;


        //查询数据库里面所有的  供应商信息，进行初始化
        List<SupplierDto> allSupplierInfoDatas = remoteSupplierService.getAllDatas();

        //放入缓存
        if(CollectionUtils.isNotEmpty(allSupplierInfoDatas)){
            for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                supplierInfoMap.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
//                SUPPLIER_INFO_CACHE.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
            }
        }
        LOGGER.info("supplierInfoMap 初始化成功 {}", JSON.toJSONString(supplierInfoMap));
    }

    public static SupplierDto getSupplierInfoById(String supplierId) {
        SupplierDto present = SUPPLIER_INFO_CACHE.getIfPresent(supplierId);
        if(present == null){
            //查询数据库里面所有的  供应商信息，进行初始化
            List<SupplierDto> allSupplierInfoDatas = remoteSupplierServicestatic.getAllDatas();
            //放入缓存
            if(CollectionUtils.isNotEmpty(allSupplierInfoDatas)){
                for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                    supplierInfoMap.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
                        SUPPLIER_INFO_CACHE.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
                }
            }
            LOGGER.info("过期后重新加载，supplierInfoMap = {}", JSON.toJSONString(supplierInfoMap));
            return SUPPLIER_INFO_CACHE.getIfPresent(supplierId);
        }
        return present;
    }

    public static String getSupplierNameInfoById(String supplierId) {
        Optional<SupplierDto> supplierDto = Optional.ofNullable(getSupplierInfoById(supplierId));
        return supplierDto.isPresent() ? supplierDto.get().getCompany() : null;
    }

    public static void invalidate(String supplierId) {
        SUPPLIER_INFO_CACHE.invalidate(supplierId);
    }

}
