package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.DuiBaSupplyOrdersDto;
import cn.com.duiba.supplier.center.api.dto.WxRedSendDTO;
import cn.com.duiba.supplier.center.api.dto.item.PurchaseItemResult;
import cn.com.duiba.supplier.center.api.enums.DuiBaSupplyOrdersStatusEnum;
import cn.com.duiba.supplier.center.api.request.order.*;
import cn.com.duiba.supplier.center.api.response.PurchaseOrderResponse;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteDuiBaSupplyOrderService {

    PurchaseOrderResponse purchaseOrder(DuiBaSupplyOrderPurchaseRequest request);

    DuiBaSupplyOrdersDto findByThirdOrderNumAndAppId(String thirdOrderNum, Long appId);

    List<DuiBaSupplyOrdersDto> findByThirdOrderNum(String thirdOrderNum);

    /**
     * 使用参数查询
     * 供应商主订单号 经销商主单号
     * @param querySupplyDTO
     * @return
     */
    List<DuiBaSupplyOrdersDto> findByParams(QuerySupplyDTO querySupplyDTO);

    DuiBaSupplyOrdersDto findBySupplyOrderNum(Long supplyOrderNum);

    boolean updateRemarksByOrderNum(Long supplyOrderNum, String remarks);

    @Deprecated
    boolean expressSend(Long supplyOrderNum, String expressName, String expressNo);

    boolean expressfix(Long supplyOrderNum, String expressInfo);

    boolean expressSendNew(Long supplyOrderNum, Long ordersItemId, String expressName, String expressNo);

    Page<DuiBaSupplyOrdersDto> findPage(QueryDuiBaSupplyOrdersPageRequest query);

    Integer findTotalCount(QueryDuiBaSupplyOrdersPageRequest query);

    List<DuiBaSupplyOrdersDto> findList(QueryDuiBaSupplyOrdersPageRequest query);

    /**
     * 取消待发货实物订单
     * @param supplyOrderNum  采购单号
     * @param cancelReason    取消原因
     * @throws BizException   取消失败抛出异常
     */
    @Deprecated
    void cancelObjectOrder(Long supplyOrderNum, String cancelReason) throws BizException;

    /**
     * 取消待发货实物订单，子订单纬度
     * @param supplyOrderNum
     * @param ordersItemId
     * @param cancelReason
     * @throws BizException
     */
    void cancelObjectOrderNew(Long supplyOrderNum, Long ordersItemId, String cancelReason) throws BizException;

    /**
     * 根据采购单号 查询APP名称
     * DuiBaSupplyOrdersDto对象只会返回两个值  appName和supplyOrderNum,supplier,sku_info
     * @param supplyOrderNums
     * @return
     */
    List<DuiBaSupplyOrdersDto> findAppNameBySupplyOrderNum(List<Long> supplyOrderNums);

    /**
     * 修改采购单信息
     * @param supplyOrderInfoRequest
     * @return
     */
    boolean updateOrderInfo(SupplyOrderInfoRequest supplyOrderInfoRequest);

    /**
     * 查找最新的一条采购单
     * @param appId
     * @return
     */
    DuiBaSupplyOrdersDto findBestNewByAppId(Long appId);

    /**
     * 根据采购单号查询数据
     */
    List<DuiBaSupplyOrdersDto> findListBySupplyOrderNum(List<Long> list);

    /**
     * 根据三方订单号查询数据
     */
    List<DuiBaSupplyOrdersDto> findListByThirdOrderNum(List<String> list);

    /**
     * 采购单强制成功
     * @param supplyOrderNum
     * @param remark
     * @return
     */
    Boolean maskOrderComplete(Long supplyOrderNum, DuiBaSupplyOrdersStatusEnum statusEnum, String remark) throws BizException;

    /**
     * 重试采购单(目前只支持虚拟商品)
     */
    Boolean retrySupplierOrder(Long supplyOrderNum) throws BizException;
    /**
     * 荣数重试采购单(目前只支持虚拟商品)
     * 支持失败状态的采购单重试-一般是不支持的，这家比较特殊
     */
    Boolean rsRetrySupplierOrder(Long supplyOrderNum) throws BizException;

    /**
     * 采购单-优惠券类型重试
     * @param request
     */
    void couponOrderRetry(DuiBaSupplyOrderPurchaseRequest request);

    /**
     * 重庆太保定制采购单(主、子)订单充值
     * @param request
     * @return
     */
    PurchaseItemResult purchaseSubOrderBycChongQingTaiBao(DuiBaSupplyOrderPurchaseRequest request, Long supplySubOrderNum);

    /**
     * 重庆太保，民生权益定制采购单(主、子)订单充值 (批量)
     * @param list
     * @return
     */
    void purchaseSubOrderBycChongQingTaiBaoByList(List<DuiBaSupplyOrderPurchaseRequest> list);


    /**
     * 江苏银行定制采购单(主、子)订单充值
     * @param request
     * @return
     */
    PurchaseItemResult purchaseSubOrderByJiangsuBank(DuiBaSupplyOrderPurchaseRequest request, Long mainSupplyOrderNum,Long supplySubOrderNum);
    /**
     * 江苏银行定制采购单(主、子)订单充值 (批量)
     * @param list
     * @return
     */
    void purchaseSubOrderByJiangsuBankWhitList(List<DuiBaSupplyOrderPurchaseRequest> list,Long mainSupplyOrderNum);

    /**
     * 重庆太保定制采购单(主、子)订单重试
     * @param request
     * @return
     */
    void chongQingTaiBaoRetry(DuiBaSupplyOrderPurchaseRequest request, Long supplySubOrderNum, Long retrySupplyOrderNum);

    /**
     * 民生权益立减金主子订单重试
     * @param mainSupplyOrderNum
     */
    void minShengRetry(Long mainSupplyOrderNum);

    /**
     * 江苏银行优惠券主子订单重试
     */
    void jiangsuBankRetry(Long mainSupplyOrderNum);


    /**
     * 建总行定制
     * 根据扩展字段查询列表信息
     * @param supplyOrderNums
     * @return
     */
    List<DuiBaSupplyOrdersDto> findByExpressInfo(List<Long> appIds,List<String> expressInfo);


    List<DuiBaSupplyOrdersDto> findListByAppIdAndStatusAndModifiedTime(Long appId, List<Integer> orderStatusList, Date startTime, Date endTime);

    /**
     * 预下单领取奖励
     * @param preOrderDrawRequest
     * @return
     */
    boolean preOrderDraw(PreOrderDrawRequest preOrderDrawRequest) throws BizException;

    /**
     * 微信红包领取奖励
     * @param wxRedpackOrderDrawRequest
     * @return
     * @throws BizException
     */
    boolean wxOrderDraw(WxRedpackOrderDrawRequest wxRedpackOrderDrawRequest) throws BizException;

    /**
     * 发送微信红包通知
     */
    void sendWxRed(WxRedSendDTO wxRedSendDTO);
}
