package cn.com.duiba.supplier.center.api.enums;

import cn.com.duiba.supplier.center.api.dto.SupplierDto;
import cn.com.duiba.supplier.center.api.remoteservice.supplier.RemoteSupplierService;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

/**
 * 使用最近的供应商工具，方便管理后台可配置，近实时更新新的供应商，缺点是基于缓存，会有不一致的缓存问题
 * 对于新增供应商的配置，是比较方便的，满足绝大部分使用场景。
 * @Author 刘凯
 * @Date 2023/10/31 11:41 AM （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@Component
public class SupplyTypeEnumUtil implements CommandLineRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(SupplyTypeEnumUtil.class);



    @Autowired
    private RemoteSupplierService remoteSupplierService;

    private static RemoteSupplierService remoteSupplierServicestatic;
    private static final Map<String,SupplierDto > supplierInfoMap = new ConcurrentHashMap<>();

    private static final Cache<String, SupplierDto> SUPPLIER_INFO_CACHE = Caffeine.newBuilder().expireAfterWrite(3, TimeUnit.MINUTES).maximumSize(100)
            .build(new CacheLoader<String, SupplierDto>() {
                @Override
                public @Nullable SupplierDto load(@NonNull String key) throws Exception {
                        if(supplierInfoMap.get(key) == null){
                            //查询数据库里面所有的  供应商信息，进行初始化
                            List<SupplierDto> allSupplierInfoDatas = remoteSupplierServicestatic.getAllDatas();

                            //放入缓存
                            if(CollectionUtil.isNotEmpty(allSupplierInfoDatas)){
                                for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                                    supplierInfoMap.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
                                }
                            }
                            LOGGER.info("过期后，重新加载，supplierInfoMap = {}", JSON.toJSONString(supplierInfoMap));
                        }
                        return supplierInfoMap.get(key);
                }
            });

    @Override
    public void run(String... args) throws Exception {
        //方便可以在 cache 中使用
        remoteSupplierServicestatic = remoteSupplierService;


        //查询数据库里面所有的  供应商信息，进行初始化
        List<SupplierDto> allSupplierInfoDatas = remoteSupplierService.getAllDatas();

        //放入缓存
        if(CollectionUtil.isNotEmpty(allSupplierInfoDatas)){
            for (SupplierDto allSupplierInfoData : allSupplierInfoDatas) {
                supplierInfoMap.put(allSupplierInfoData.getId().toString(),allSupplierInfoData);
            }
        }
        LOGGER.info("supplierInfoMap 初始化成功 {}", JSON.toJSONString(supplierInfoMap));
    }

    public static SupplierDto getSupplierInfoById(String supplierId) {
        return SUPPLIER_INFO_CACHE.getIfPresent(supplierId);
    }
}
