package cn.com.duiba.supplier.center.api.response;


import cn.com.duiba.supplier.center.api.enums.ErrorCodeEnums;

/**
 * Created by hww on 2018/11/28 12:03 PM.
 */
public class PurchaseOrderResponse extends AbstractResponse {

    private static final long serialVersionUID = -1714760391377548901L;

    /** 采购单订单号 */
    private Long supplyOrderNum;
    /** 运费 */
    private Long freight;
    /** 商品总金额 不包含运费 */
    private Long orderPrice;
    /** 采购单总价 */
    private Long totalPrice;

    public Long getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Long totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Long getSupplyOrderNum() {
        return supplyOrderNum;
    }

    public void setSupplyOrderNum(Long supplyOrderNum) {
        this.supplyOrderNum = supplyOrderNum;
    }

    public Long getFreight() {
        return freight;
    }

    public void setFreight(Long freight) {
        this.freight = freight;
    }

    public Long getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(Long orderPrice) {
        this.orderPrice = orderPrice;
    }

    public static PurchaseOrderResponse success() {
        PurchaseOrderResponse response = new PurchaseOrderResponse();
        response.setSuccess(true);
        response.setResultCode(ErrorCodeEnums.RC_00001.getCode());
        response.setResultMessage(ErrorCodeEnums.RC_00001.getMessage());
        return response;
    }

    public static PurchaseOrderResponse fail() {
        return fail(ErrorCodeEnums.RC_00002);
    }

    public static PurchaseOrderResponse fail(ErrorCodeEnums code) {
        return fail(code.getCode(), code.getMessage());
    }

    public static PurchaseOrderResponse fail(String code, String message) {
        PurchaseOrderResponse response = new PurchaseOrderResponse();
        response.setSuccess(false);
        response.setResultCode(code);
        response.setResultMessage(message);
        return response;
    }



}
