package cn.com.duiba.supplier.center.api.remoteservice.supply.phonebill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.phonebill.ChannelCallbackDto;

import java.util.List;

/**
 * 兑吧话费采购处理
 *
 * @author haojiahong
 * @date 2022-04-22
 */
@AdvancedFeignClient
public interface RemotePhonebillSupplyService {

    /**
     * 第三方话费渠道，回调处理
     *
     * @param channelCallbackDto
     * @return
     */
    Boolean channelCallback(ChannelCallbackDto channelCallbackDto);

    /**
     * 重新推送卡池无记录的订单
     * @param supplyOrderNumList
     */
    void pushKaChiNotRecordOrder(List<Long> supplyOrderNumList);
}
