package cn.com.duiba.supplier.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
* 商品复制结构关系表
*/
public class GoodsCopyRelationDto implements Serializable {

    private static final long serialVersionUID = 8065426618925769915L;


    /**
    * 是否删除关系记录（0-未删除，1-已删除）
    */
    private Integer deleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 主键
    */
    private Long id;

    /**
    * 商品ID
    */
    private Long itemId;

    /**
    * 源商品ID（最开始被复制的商品ID）
    */
    private Long originItemId;

    /**
    * 父商品ID（被复制的商品ID）
    */
    private Long parentItemId;

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getOriginItemId() {
        return originItemId;
    }

    public void setOriginItemId(Long originItemId) {
        this.originItemId = originItemId;
    }

    public Long getParentItemId() {
        return parentItemId;
    }

    public void setParentItemId(Long parentItemId) {
        this.parentItemId = parentItemId;
    }
}

