package cn.com.duiba.supplier.center.api.enums;

import cn.com.duiba.order.center.api.constant.StatusIntEnum;
import java.util.Objects;

public enum DuiBaSupplyOrdersStatusEnum {

    PRE(10, "预下单"),
    CREATE(100, "初始化"),
    WAIT_SEND(200, "待发货"),
    SUCCESS(998, "成功"),
    FAIL(999, "失败"),
    PROCESSING(997,"处理中")
    ;

    private Integer code;
    private String desc;

    DuiBaSupplyOrdersStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DuiBaSupplyOrdersStatusEnum ofValue(int code){
        for (DuiBaSupplyOrdersStatusEnum type : values()){
            if(Objects.equals(code,type.getCode())){
                return type;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
}
