package cn.com.duiba.supplier.channel.service.api.enums.channel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author fmk
 * @since 2024/1/2
 */
@RequiredArgsConstructor
@Getter
public enum YingShengShuHuiCodeEnum {

    QY1001("1001", "成功", ""),
    QY1002("1002", "签名验证失败", "密钥或者签名方式错误"),
    QY1003("1003", "必填参数缺失", "缺失关键参数"),
    QY1004("1004", "系统异常", "未定义的非预期错误"),
    QY1005("1005", "产品信息不存在", "传入了错误的产品类型"),
    QY1006("1006", "ip访问受限", "非白名单ip访问"),
    QY1007("1007", "处理中", "订单处理中,需要查询确认订单状态"),
    QY1008("1008", "失败", "下单失败"),
    QY1009("1009", "签名参数缺失", "请求头不含sign"),
    QY1010("1010","代理商信息不存在", "merid错误");

    private static final Map<String, YingShengShuHuiCodeEnum> enumMapPartitionByCode = Lists.newArrayList(values()).stream()
            .collect(Collectors.toMap(YingShengShuHuiCodeEnum::getCode, Function.identity(), (v1,v2) -> v1));


    private final String code;

    private final String desc;

    private final String remark;

    /**
     * 根据code查找
     *
     * @param code code
     * @return YingShengShuHuiCodeEnum
     */
    public static YingShengShuHuiCodeEnum getByCode(String code) {
        return enumMapPartitionByCode.get(code);
    }

}
