package cn.com.duiba.supplier.channel.service.api.remoteservice.yingshengshuhui;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.yingshengshuhui.YingShengShuHuiZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.ccb.CcbCountCoinsResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * RemoteMeiTuanZcService
 *
 * @author fmk
 * @since 2024/1/2
 */
@AdvancedFeignClient
public interface RemoteYingShengShuHuiZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<YingShengShuHuiZcReq> request);

    /**
     * 查询发放结果
     * 暂未实现
     * @param bizType 业务类型
     *        {@link BizTypeEnum}
     * @param bizNo 业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<CcbCountCoinsResp> distributeResult(Integer bizType, String bizNo);

}
