package cn.com.duiba.supplier.channel.service.api.dto.response.alipay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 支付宝批次详情
 * @author yangyukang
 */
@Data
public class AlipayActivityInfoResp implements Serializable {

    private static final long serialVersionUID = -1166374025904048403L;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 支付宝活动名称
     */
    private String alipayActName;

    /**
     * 支付宝活动状态,CREATED="已创建",PUBLISHING="发布中",PUBLISHED_FAILED="发布失败",GREY="已发布(白名单验证中)",GOING="已发布",PAUSED="已暂停",ENDED="已结束"
     */
    private String alipayActStatus;

    /**
     * 卡类型，CREDIT:信用卡,DEBIT:借记卡,DEBIT_CREDIT:借记卡或信用卡
     */
    private String bankCardType;

    /**
     * 银行卡卡bin配置，列表类型,以逗号分隔的字符串数组
     */
    private String cardBinList;

    /**
     * 活动总预算值，以分为单位
     */
    private Long totalBudget;

    /**
     * 最少发放红包份数，比如：88代表此活动最少能发88次红包
     */
    private Long minSendCount;

    /**
     * 红包使用说明文案
     */
    private List<String> userInstructionList;

    /**
     * 立减类型 reduce:满立减(满5元减3元) random:随机立减(满10元随机立减1元到3元
     */
    private String discountType;

    /**
     * 优惠立减门槛金额 以分为单位
     */
    private Long discountThresholdAmt;

    /**
     * 优惠立减值, 分为单位如果discount_type=reduce，那么就是具体的优惠立减额，比如：999代表满足一定金额减9.99元；如果discount_type=random，那么就是"最小额-最大额"，比如:99-990，代表立减范围从0.99元到9.99元随机决策
     */
    private String discountValue;

    /**
     * 红包发放开始时间
     */
    private Date sendBeginTime;

    /**
     * 红包发放结束时间
     */
    private Date sendEndTime;

    /**
     * 代表限定周期时间类型 DAY_OF_WEEK:星期维度
     */
    private String cyclePeriodType;

    /**
     * 代表发放周期类型(cycle_period_type)下具体值。比如：cycle_period_type=DAY_OF_WEEK，cycle_period_value=["MON","TUE","WEB"],代表：周一、周二、周三
     */
    private String cyclePeriodValue;

    /**
     * 代表在周期时间范围下，子周期限定时间类型SECOND_OF_DAY:一天内具体时间点(秒为单位)
     */
    private String subCyclePeriodType;

    /**
     * 代表发放周期类型(cycle_period_type)下具体值。比如：cycle_period_type=SECOND_OF_DAY，cycle_period_value=["01:53:28-02:53:28","05:10:10-08:30:30"],代表：子时间段为每天的01点53分28秒到02点53分28秒，05点10分10秒到08点30分30秒
     */
    private String subCyclePeriodValue;

    /**
     * 时间周期类型 ABSOLUTELY:绝对时间RELATIVE:相对时间
     */
    private String couponAvailablePeriodType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间情况下，红包发放开始时间
     */
    private Date couponAbsolutelyBeginTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间下红包发放结束时间
     */
    private Date couponAbsolutelyEndTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包发放开始时间周期类型 DAYS:天级 MINUTES:分钟级
     */
    private String couponRelativeBeginRoundingType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包开始时间相对值，比如:coupon_relative_begin_rounding_type=DAYS coupon_relative_begin_value=1 代表次日凌晨开始生效 比如:coupon_relative_begin_rounding_type=MINUTES coupon_relative_begin_value=100 代表当前时间100分钟后开始生效
     */
    private Long couponRelativeBeginValue;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包发放结束时间周期类型 DAYS:天级 MINUTES:分钟级
     */
    private String couponRelativeEndRoundingType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包开始时间相对值，比如:coupon_relative_end_rounding_type=MINUTES coupon_relative_end_value=100 代表从生效时间开始，有效期持续为100分钟
     */
    private Long couponRelativeEndValue;

    /**
     * 该活动上已领取红包数量 比如:999代表该活上已被领取999个红包 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long receiveCount = 0L;

    /**
     * 该活动上已领取红包金额，分为单位 999代表已领取9.99元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long receiveAmount = 0L;

    /**
     * 该活动上已核销红包数量 比如:888代表该活上所有领取的红包中已核销了888个红包 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long usedCount = 0L;

    /**
     * 该活动上已核销红包金额，分为单位 888代表已领取8.88元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long usedAmount = 0L;

    /**
     * 该活动上已退款的红包总金额，分为单位 999代表总共退款9.99元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long refundAmount = 0L;

    /**
     * 该活动上剩余红包金额，分为单位 888代表剩余8.88元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long availableAmount = 0L;

}
