package cn.com.duiba.supplier.channel.service.api.dto.request.alipay;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 支付宝立减金发放
 * @author lizhi
 * @date 2023/4/17 1:36 PM
 */
@Data
public class AlipayCouponCardReq implements Serializable {
    
    private static final long serialVersionUID = -4429821352256408204L;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：UID为用户唯一标识，可通过授权方式获取，具体见产品文档。
     * 特殊可选，最大长度16
     */
    @Size(max = 16, message = "userId不能超过16")
    private String userId;

    /**
     * 映射user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    @Size(max = 128, message = "openId不能超过128")
    private String openId;

    /**
     * 支付宝用户ID 
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：若手机号为非用户注册支付宝账号，则会发放失败。
     * 特殊可选，最大长度128
     */
    @Size(max = 128, message = "loginId不能超过128")
    private String loginId;

    /**
     * 该参数将先匹配用户手机号对应支付宝账号，若存在且完成实名认证则以此支付宝账号发放，若该支付宝账号未完成实名认证则发放失败；若用户手机号对应支付宝账号不存在，则再匹配用户手机号绑定支付宝账号。
     * 若用户手机号绑定多个支付宝账号，则以系统判定的常用支付宝账号为准。请优先使用user_id和logon_id。
     * 特殊可选，最大长度11
     */
    @Size(max = 11, message = "phoneId不能超过11")
    private String phoneId;

    /**
     * 数字分行活动id
     * 必选，最大长度32
     */
    @NotBlank(message = "actId不能为空")
    @Size(max = 32, message = "actId不能超过32")
    private String actId;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    @NotBlank(message = "appId不能为空")
    @Size(max = 32, message = "appId不能超过32")
    private String appId;
}
