package cn.com.duiba.supplier.channel.service.api.dto.response.alipay;

import lombok.Data;

import java.io.Serializable;

/**
 * 支付宝立减金发放响应结果
 * @author lizhi
 * @date 2023/4/17 2:10 PM
 */
@Data
public class AlipayCouponCardResp implements Serializable {
    
    private static final long serialVersionUID = 8633590332396619339L;
    
    /**
     * 活动id
     * 必选，最大长度64
     */
    private String activityId;

    /**
     * 活动流水唯一记录
     * 必选，最大长度64
     */
    private String activityOrderId;

    /**
     * reduce:满立减(满5元减3元)
     * random:随机立减(满10元随机立减1元到3元)
     * 必选，最大长度32
     */
    private String discountType;

    /**
     * 优惠门槛金额
     * 比喻:
     * A.满5元减3元，则值是500
     * B.满10元随机立减1元到3元,则值是1000
     * 整数类型，以分为单位。
     * 必选，最大长度16
     */
    private Long discountThresholdAmt;
    
    /**
     * 比喻:
     * A.满5元减3元，则值是300(单位：分)
     * B.满10元随机立减1元到3元,则值是具体的金额，如果随机1.5元，则值为150(单位:分)
     * 
     */
    private Long discountValue;

    /**
     * 以分为单位，比喻599，代表5.99元的面额
     * 必选，最大长度10
     */
    private Long sendAmount;

    /**
     * 券平台唯一id
     */
    private String voucherId;

    /**
     * 接收渠道红包的，脱敏后的支付宝登录号
     */
    private String accountNo;

    /**
     * 支付宝响应结果json字符串
     */
    private String body;
}
