package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 业务类型
 * @author lizhi
 * @date 2023/4/10 11:38 AM
 */
@Getter
@AllArgsConstructor
public enum BizTypeEnum {
    DUI_BA_GOODS(1, "兑吧商品库"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
    
    private static final Map<Integer, BizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    public static BizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
