package cn.com.duiba.supplier.channel.service.api.dto.request;

import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.NotifyTypeEnum;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/4/10 4:08 PM
 */
@Data
public class BaseReq<T extends Serializable> implements Serializable {
    
    private static final long serialVersionUID = 8594994864388933701L;

    /**
     * 渠道类型
     * {@link ChannelTypeEnum}
     */
    @NotNull(message = "channelType不能为空")
    private Integer channelType;

    /**
     * 业务类型
     * {@link BizTypeEnum}
     */
    @NotNull(message = "bizType不能为空")
    private Integer bizType;

    /**
     * 业务方唯一单号
     * 注意：实际长度不能大于渠道长度-6，比如渠道最大长度为32，则bizNo最大长度为26
     * （实际生成商户单号默认规则：业务类型+分隔符+bizNo+分隔符+重试次数，渠道实现类可重写规则）
     */
    @NotBlank(message = "bizNo不能为空")
    @Size(max = 64, message = "bizNo不能超过64")
    private String bizNo;

    /**
     * 是否需要通知结果，默认需要
     * {@link NotifyTypeEnum}
     */
    @NotNull(message = "notifyType不能为空")
    private Integer notifyType;

    /**
     * 回调结果的mq的topic
     */
    @Size(max = 64, message = "mqTopic不能超过64")
    private String mqTopic;

    /**
     * 回调结果的mq的tag
     */
    @Size(max = 64, message = "mqTag不能超过64")
    private String mqTag;

    /**
     * 渠道需要的其他参数
     */
    @Valid
    private T channelParams;

    /**
     * 用于搜索日志的编码，无其他用处，可不传
     * （目前积分商城的技术支持，会通过积分商城短链url上的code码搜索日志查看发放结果，其他业务建议用单号搜索日志）
     */
    @Size(max = 64, message = "logCode不能超过64")
    private String logCode;
}
