package cn.com.duiba.supplier.channel.service.api.dto.response.wx;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/2/21 15:16
 */
@Data
public class WxV3NotifyResp implements Serializable {
    
    private static final long serialVersionUID = -495914212687518334L;

    /**
     * 通知Id
     */
    private String id;
    
    /**
     * 通知创建的时间
     */
    private String createTime;
    
    /**
     * 通知的类型
     * 代金券用券回调通知的类型为COUPON.USE。
     */
    private String eventType;
    
    /**
     * 通知的资源数据类型
     * 代金券用券回调通知为encrypt-resource。
     */
    private String resourceType;
    
    /**
     * 回调摘要
     */
    private String summary;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 原resource的json
     */
    private String resource;

    /**
     * resource解密后的json
     */
    private String body;
}
