package cn.com.duiba.supplier.channel.service.api.dto.request.bankmoretransfer;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 身边云银行卡大额转账请求参数
 * @author yanggyukagn
 * @date 2024/1/24 1:36 PM
 */
@Data
public class ShenbyBankMoreTransferDetailReq implements Serializable {

    private static final long serialVersionUID = 7414485349948078311L;

    /**
     * 商家明细单号
     * 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识，要求此参数只能由数字、大小写字母组成
     * 必填，string(32)
     */
    @NotBlank(message = "merOrderId must not be null")
    @Size(max = 32, message = "outDetailNo不能超过32")
    private String merOrderId;

    /**
     * 金额
     */
    @NotNull(message = "amt must not be null")
    private Long amt;

    /**
     * 收款人名称
     */
    @NotBlank(message = "payeeName must not be null")
    private String payeeName;

    /**
     * 收款人账号
     */
    @NotBlank(message = "payeeAcc must not be null")
    private String payeeAcc;

    /**
     * 收款人身份证号
     */
    @NotBlank(message = "idCard must not be null")
    private String idCard;

    /**
     * 收款人手机号
     */
    @NotBlank(message = "mobile must not be null")
    @Size(max = 11, min = 11, message = "手机号不能超过11")
    private String mobile;

    /**
     * 备注
     */
    private String memo;
}
