package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 渠道类型
 * @author lizhi
 * @date 2023/4/10 11:38 AM
 */
@Getter
@AllArgsConstructor
public enum ChannelTypeEnum {
    ALI_PAY_COUPON(1, "支付宝立减金"),
    TRANSFER_BATCHES(2, "微信商家转账到零钱"),
    WX_FAVOR(3, "微信发放代金券"),
    WX_TRANSFER_JI_GAO(4, "继皋直充-微信到零钱"),
    I_QI_YI_ZC(5, "爱奇艺-直充"),
    ALIPAY_COUNT_COINS(6, "支付宝数币红包"),
    CCB_PAY_COUNT_COINS(7, "建行数币红包"),
    MEI_TUAN_STORE_YIN_SHENG_SHU_HUI(8, "美团到店-银盛数惠"),
    YI_AN_YOU_KU(9, "优酷会员-易安"),
    TE_LAI_DIAN_COUPON_ZC(10, "特来电卡劵直充"),
    TUAN_YOU_YI_AN(11,  "团油-易安"),
    CLOUD_360_VIP_ZC(12, "360安全云盘会员"),
    HUA_FEI_CHONG_DA(13,"无票话费-充达"),
    BA_WANG_CHA_JI_QIMAI(14, "霸王茶姬-企迈"),
    WX_TRANSFER_KA_CHI(15, "微信到零钱-卡池"),
    MI_GU_VIDEO_VIP_TE_ZHEN(16, "咪咕视频会员-特祯"),
    QQ_VIP_TE_ZHEN(17, "QQ会员-特祯"),
    TEN_XUN_QQ_MUSIC_VIP_TE_ZHEN(18, "腾讯QQ音乐会员-特祯"),
    DIDI_CAR_COUPON_TE_ZHEN(19, "滴滴快车代金劵-特祯"),
    RUI_XING_COFFE_ZC_TE_ZHEN(20, "瑞希咖啡直充-特祯"),
    Q_B_DIAN_DIAN(21, "Q币-点点"),
    NAI_XUE_ZC(22, "奈雪-直充"),
    WANG_YI_YUN_VIP_DING_XIN(24, "网易云音乐会员-鼎信"),
    BAI_DU_CLOUD_VIP_DING_XIN(25, "百度网盘会员-鼎信"),
    I_QI_YI_DIAN_DIAN(26, "爱奇艺-点点"),
    TEN_XUN_VIDEO_VIP_DING_XIN(27, "腾讯视频会员-鼎信"),
    FEI_HAN_BI_LI_BI_LI_VIP(28, "哔哩哔哩会员-飞翰"),
    YI_PAI_XI_MA_LA_YA_VIP(29, "喜马拉雅会员-易派"),
    FU_LU_MANG_GUO_TV_VIP(30, "芒果TV会员-福禄"),
    WX_RED_PACKET_JI_GAO(31, "继皋直充-微信红包"),
    TENCENT_VIDEO_VIP_DIAN_DIAN(33, "腾讯视频-点点"),
    J_D_E_CARD(32, "京东E卡"),
    HANG_LV_ZONG_HENG_ZC(35, "航旅纵横直充"),
    WX_TRANSFER_SHEN_BIAN_YUN(34, "身边云-微信零钱"),
    HUA_FEI_KA_CHI(36,"有票话费-卡池"),
    YOUKU_VIP_ZC(37, "优酷会员-直充"),

    YOUKU_YIPAI(39, "优酷会员-易派"),
    CNPC_ANYI(40, "中石油-安怡"),
    SINOPEC_ANYI(41, "中石化-安怡"),
    HONG_EN_ZC(42,"洪恩直充"),

    WX_MORE_TRANSFER_SHEN_BIAN_YUN(43,"身边云-微信大额转账"),
    BANK_MORE_TRANSFER_SHEN_BIAN_YUN(44,"身边云-银行卡大额转账"),

    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
