package cn.com.duiba.supplier.channel.service.api.dto.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 通用响应
 * @author lizhi
 * @date 2023/4/10 4:03 PM
 */
@Data
public class CloseResp implements Serializable {

    private static final long serialVersionUID = 2991435633620889367L;

    /**
     * 是否关闭成功
     */
    private boolean success;

    /**
     * 错误信息，请求失败时有值
     */
    private String errorMsg;
    
    public static CloseResp buildErr(String errMsg) {
        CloseResp resp = new CloseResp();
        resp.setSuccess(false);
        resp.setErrorMsg(errMsg);
        return resp;
    }
    
    public static CloseResp buildSuccess() {
        CloseResp resp = new CloseResp();
        resp.setSuccess(true);
        return resp;
    }
}
