package cn.com.duiba.supplier.channel.service.api.dto.request.wx.transfer;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信到零钱-卡池
 * @author lizhi
 * @date 2023/6/20 3:28 PM
 */
@Data
public class KaChiWxTransferReq implements Serializable {
    
    private static final long serialVersionUID = 49874502047368800L;

    /**
     * 会员ID
     * 必填
     */
    private String userId;

    /**
     * 充值帐号	
     * 支付宝账户/微信openid
     */
    private String mobile;

    /**
     * 商品ID	
     */
    private String productId;

    /**
     * 批次号	
     */
    private String infoMsg;

    /**
     * 自定义转账金额	
     * 只支持到小数点2位，单位元，例如88.88
     */
    private String hongBaoValue;

    /**
     * 自定义转账备注	
     * 不可超过240字符，一个中文算2个字符，可以用#data#替代金额，请用URLEncoder编码传输
     */
    private String hBaoActNote;
}
