package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author yyk
 * @since 2024/6/22
 */
@RequiredArgsConstructor
@Getter
public enum SuXiStatusCodeEnum {

    SUCCESS("000", "成功"),
    FAILED("410", "充值失败"),
    PROCESSING("210.", "充值中"),
    ;
    public static SuXiStatusCodeEnum getByCode(String code) throws BizException {
        for (SuXiStatusCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }

    private final String code;

    private final String description;

}
