package cn.com.duiba.supplier.channel.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.response.order.ChannelOrderDto;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelTypeEnum;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/2/22 18:11
 * @description:
 */
@AdvancedFeignClient
public interface RemoteChannelOrderService {

    /**
     * 根据三方唯一单号查询
     *
     * @param respSerialNo 供应商三方唯一单号
     * @param channelType  渠道类型
     * @return 订单
     */
    ChannelOrderDto selectByRespSerialNo(String respSerialNo, Integer channelType);


    /**
     * select by out biz no
     *
     * @param outBizNo        out biz no
     * @param channelTypeList channel type list {@link ChannelTypeEnum#getType()}
     * @return {@link List}<{@link ChannelOrderDto}>
     */
    List<ChannelOrderDto> selectByOutBizNo(String outBizNo, List<Integer> channelTypeList);

    /**
     * 根据bizNos查询
     *
     * @param bizNos   业务方唯一单号集合
     * @return 结果
     */
    List<ChannelOrderDto> selectByBizNos(List<String> bizNos);
}
