package cn.com.duiba.supplier.channel.service.api.dto.request.alipay;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 支付宝数币红包发放
 * @author yangyukang
 * @date 2023/10/19
 */
@Data
public class AlipayCountCoinsReq implements Serializable {

    private static final long serialVersionUID = 1014546863231727969L;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：UID为用户唯一标识，可通过授权方式获取，具体见产品文档。
     * 特殊可选，最大长度16
     */
    @Size(max = 16, message = "userId不能超过16")
    private String userId;

    /**
     * 映射user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    @Size(max = 128, message = "openId不能超过128")
    private String openId;

    /**
     * 支付宝用户ID 
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：若手机号为非用户注册支付宝账号，则会发放失败。
     * 特殊可选，最大长度128
     */
    @Size(max = 128, message = "loginId不能超过128")
    private String loginId;

    /**
     * 活动id，获取方式：调用方通过活动创建接口alipay.marketing.campaign.drawcamp.create 生成；联系支付宝运营同学获取（适用于支付宝平台活动，由合作伙伴调用触发）
     * 必选，最大长度64
     */
    @Size(max = 64, message = "actId不能超过64")
    private String actId;

    /**
     * 用户参与活动的手机号（如果是用户直接输入手机号的活动形式，该项必填，作为识别用户的依据）
     * 特殊可选，最大长度15
     */
    @Size(max = 15, message = "phone不能超过15")
    private String phone;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    @NotBlank(message = "appId不能为空")
    @Size(max = 32, message = "appId不能超过32")
    private String appId;
}
